//+------------------------------------------------------------------+
//|                                               Naive Forecast.mq5 |
//|                                                        AIS Forex |
//|                        https://www.mql5.com/ru/users/aleksej1966 |
//+------------------------------------------------------------------+
#property copyright "AIS Forex"
#property link      "https://www.mql5.com/ru/users/aleksej1966"
#property version   "1.00"
#property indicator_chart_window
#property indicator_buffers 1
#property indicator_plots   1

#property indicator_type1  DRAW_LINE
#property indicator_label1 "Naive Forecast"
#property indicator_color1 clrBlue
#property indicator_width1 1
#property indicator_style1 STYLE_SOLID

enum _diff {Diff1,Diff2,Diff3,
            Diff12,//Diff1+Diff2
            Diff13,//Diff1+Diff3
            Diff23,//Diff2+Diff3
            Diff123//Diff1+Diff2+Diff3
           };

input _diff Difference=Diff1;
input uchar iPeriod=14;

int period;
double buffer[],coeff[];
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
//--- indicator buffers mapping
   SetIndexBuffer(0,buffer,INDICATOR_DATA);
   PlotIndexSetInteger(0,PLOT_SHIFT,1);
   ArraySetAsSeries(buffer,true);

   if(Difference==Diff1)
     {
      period=MathMax(2,iPeriod);
      Resize();
      double denom=period;
      coeff[1]=1/denom;
      coeff[period-1]=-1/denom;
     }
   if(Difference==Diff2)
     {
      period=MathMax(4,iPeriod);
      Resize();
      double denom=period-1;
      coeff[1]=1/denom;
      coeff[2]=-1/denom;
      coeff[period-2]=-1/denom;
      coeff[period-1]=1/denom;
     }

   if(Difference==Diff3)
     {
      period=MathMax(6,iPeriod);
      Resize();
      double denom=period-2;
      coeff[1]=1/denom;
      coeff[2]=-2/denom;
      coeff[3]=1/denom;
      coeff[period-3]=-1/denom;
      coeff[period-2]=2/denom;
      coeff[period-1]=-1/denom;
     }

   if(Difference==Diff12)
     {
      period=MathMax(4,iPeriod);
      Resize();
      double d1=2*period,d2=2*(period-1);
      coeff[1]=1/d1+1/d2;
      coeff[2]=-1/d2;
      coeff[period-2]=-1/d2;
      coeff[period-1]=-1/d1+1/d2;
     }

   if(Difference==Diff13)
     {
      period=MathMax(6,iPeriod);
      Resize();
      double d1=2*period,d3=2*(period-2);
      coeff[1]=1/d1+1/d3;
      coeff[2]=-2/d3;
      coeff[3]=1/d3;
      coeff[period-3]=1/d3;
      coeff[period-2]=-2/d3;
      coeff[period-1]=-1/d1+1/d3;
     }

   if(Difference==Diff23)
     {
      period=MathMax(6,iPeriod);
      Resize();
      double d2=2*(period-1),d3=2*(period-2);
      coeff[1]=1/d2+1/d3;
      coeff[2]=-1/d2-2/d3;
      coeff[3]=1/d3;
      coeff[period-3]=1/d3;
      coeff[period-2]=-1/d2-2/d3;
      coeff[period-1]=1/d2+1/d3;
     }

   if(Difference==Diff123)
     {
      period=MathMax(6,iPeriod);
      Resize();
      double d1=3*period,d2=3*(period-1),d3=3*(period-2);
      coeff[1]=1/d1+1/d2+1/d3;
      coeff[2]=-1/d2-2/d3;
      coeff[3]=1/d3;
      coeff[period-3]=1/d3;
      coeff[period-2]=-1/d2-2/d3;
      coeff[period-1]=-1/d1+1/d2+1/d3;
     }

   coeff[0]=1;
   period++;
//---
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int32_t rates_total,
                const int32_t prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int32_t &spread[])
  {
//---
   if(rates_total>prev_calculated)
     {
      ArraySetAsSeries(open,true);

      int bars=prev_calculated>0? rates_total-prev_calculated-1:rates_total-period-1;

      for(int i=bars;i>=0;i--)
        {
         double res=0;
         for(int j=0;j<period;j++)
            res=res+coeff[j]*open[i+j];

         buffer[i]=res;
        }
     }
//--- return value of prev_calculated for next call
   return(rates_total);
  }

//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void Resize()
  {
//---
   ArrayResize(coeff,period+1);
   ArrayInitialize(coeff,0);
//---
  }
//+------------------------------------------------------------------+
